/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.proxies;

import com.yurtmod.init.Content;
import com.yurtmod.proxies.CommonProxy;
import com.yurtmod.structure.StructureType;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInitRenders() {
        this.registerVariantRenders();
        this.register(Content.ITEM_TENT_CANVAS, new int[0]);
        this.register(Content.ITEM_YURT_WALL, new int[0]);
        this.register(Content.ITEM_TEPEE_WALL, new int[0]);
        this.register(Content.ITEM_BEDOUIN_WALL, new int[0]);
        this.register(Content.ITEM_MALLET, new int[0]);
        this.register(Content.ITEM_SUPER_MALLET, new int[0]);
        this.register(Content.TENT_BARRIER, new int[0]);
        this.register(Content.SUPER_DIRT, new int[0]);
        this.register(Content.YURT_WALL_OUTER, new int[0]);
        this.register(Content.YURT_WALL_INNER, new int[0]);
        this.register(Content.YURT_ROOF, new int[0]);
        this.register(Content.BEDOUIN_WALL, new int[0]);
        this.register(Content.BEDOUIN_ROOF, new int[0]);
        this.register(Content.YURT_DOOR_SMALL, new int[0]);
        this.register(Content.YURT_DOOR_MEDIUM, new int[0]);
        this.register(Content.YURT_DOOR_LARGE, new int[0]);
        this.register(Content.TEPEE_DOOR_SMALL, new int[0]);
        this.register(Content.TEPEE_DOOR_MEDIUM, new int[0]);
        this.register(Content.TEPEE_DOOR_LARGE, new int[0]);
        this.register(Content.BEDOUIN_DOOR_SMALL, new int[0]);
        this.register(Content.BEDOUIN_DOOR_MEDIUM, new int[0]);
        this.register(Content.BEDOUIN_DOOR_LARGE, new int[0]);
        int[] progress = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        this.register(Content.FRAME_YURT_WALL, progress);
        this.register(Content.FRAME_YURT_ROOF, progress);
        this.register(Content.FRAME_TEPEE_WALL, progress);
        this.register(Content.FRAME_BEDOUIN_WALL, progress);
        this.register(Content.FRAME_BEDOUIN_ROOF, progress);
    }

    private void registerVariantRenders() {
        String modelName;
        int len = StructureType.values().length;
        ResourceLocation[] RLTentItem = new ResourceLocation[len];
        ResourceLocation[] RLTepeeWall = new ResourceLocation[15];
        int i = 0;
        while (i < len) {
            modelName = "yurtmod:" + StructureType.getName(i);
            RLTentItem[i] = new ResourceLocation(modelName);
            this.register(Content.ITEM_TENT, modelName, i++);
        }
        int j = 0;
        while (j < 15) {
            modelName = Content.IB_TEPEE_WALL.getRegistryName() + "_" + j;
            RLTepeeWall[j] = new ResourceLocation(modelName);
            this.register((Item)Content.IB_TEPEE_WALL, modelName, j++);
        }
        ModelBakery.registerItemVariants((Item)Content.ITEM_TENT, (ResourceLocation[])RLTentItem);
        ModelBakery.registerItemVariants((Item)Content.IB_TEPEE_WALL, (ResourceLocation[])RLTepeeWall);
    }

    private void register(Item i, String name, int ... meta) {
        if (meta.length < 1) {
            meta = new int[]{0};
        }
        for (int m : meta) {
            ModelLoader.setCustomModelResourceLocation((Item)i, (int)m, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
        }
    }

    private void register(Item i, int ... meta) {
        this.register(i, i.getRegistryName().toString(), meta);
    }

    private void register(Block b, int ... meta) {
        Item i = Item.func_150898_a((Block)b);
        if (i != null) {
            this.register(i, meta);
        } else {
            System.out.println("[NomadicTents.ClientProxy] Tried to register render for a null ItemBlock. Skipping.");
        }
    }
}

